/*
 * Decompiled with CFR 0.152.
 */
package pl.rafsze.utils.exceptions;

import java.util.function.Consumer;
import pl.rafsze.utils.exceptions.Check;
import pl.rafsze.utils.exceptions.SneakyThrow;

public class CatchException {
    public static void with(ExceptionRunnable runnable, Consumer<Throwable> exceptionHandler) {
        Check.notNull(runnable, "Runnable cannot be null");
        Check.notNull(exceptionHandler, "Exception handler cannot be null");
        try {
            runnable.run();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
        }
    }

    public static <T> T with(ExceptionSupplier<? extends T> supplier, Consumer<Throwable> exceptionHandler, T defaultValue) {
        Check.notNull(supplier, "Supplier cannot be null");
        Check.notNull(exceptionHandler, "Exception handler cannot be null");
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return defaultValue;
        }
    }

    public static void printStackTrace(ExceptionRunnable runnable) {
        CatchException.with(runnable, Throwable::printStackTrace);
    }

    public static <T> T printStackTrace(ExceptionSupplier<? extends T> supplier, T defaultValue) {
        return CatchException.with(supplier, Throwable::printStackTrace, defaultValue);
    }

    public static void sneaky(ExceptionRunnable runnable) {
        CatchException.with(runnable, SneakyThrow::raise);
    }

    public static <T> T sneaky(ExceptionSupplier<T> supplier) {
        return CatchException.with(supplier, SneakyThrow::raise, null);
    }

    @FunctionalInterface
    public static interface ExceptionSupplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    public static interface ExceptionRunnable {
        public void run() throws Throwable;
    }
}

